/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.recipes;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.objects.items.food.ItemSandwich;
import net.dries007.tfc.objects.recipes.RecipeUtils;
import net.dries007.tfc.objects.recipes.ShapedDamageRecipe;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class SandwichRecipe
extends ShapedDamageRecipe {
    public SandwichRecipe(ResourceLocation group, CraftingHelper.ShapedPrimer input, @Nonnull ItemStack result, int damage) {
        super(group, input, result, damage);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack output = super.func_77572_b(inv);
        IFood food = (IFood)output.getCapability(CapabilityFood.CAPABILITY, null);
        if (food instanceof ItemSandwich.SandwichHandler) {
            ItemSandwich.SandwichHandler sandwich = (ItemSandwich.SandwichHandler)food;
            ArrayList<FoodData> breads = new ArrayList<FoodData>();
            ArrayList<FoodData> ingredients = new ArrayList<FoodData>();
            this.getBreadsAndIngredients(inv, breads, ingredients);
            if (breads.size() != 2 || ingredients.size() < 1) {
                return ItemStack.field_190927_a;
            }
            sandwich.initCreationFoods((FoodData)breads.get(0), (FoodData)breads.get(1), ingredients);
            sandwich.setCreationDate(CalendarTFC.PLAYER_TIME.getTicks());
        }
        return output;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        if (super.func_77569_a(inv, world)) {
            ArrayList<FoodData> breads = new ArrayList<FoodData>();
            ArrayList<FoodData> ingredients = new ArrayList<FoodData>();
            this.getBreadsAndIngredients(inv, breads, ingredients);
            return breads.size() == 2 && ingredients.size() > 0;
        }
        return false;
    }

    private void getBreadsAndIngredients(InventoryCrafting inv, List<FoodData> breads, List<FoodData> ingredients) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack ingredientStack = inv.func_70301_a(i);
            IFood ingredientCap = (IFood)ingredientStack.getCapability(CapabilityFood.CAPABILITY, null);
            if (ingredientCap == null) continue;
            if (ingredientCap.isRotten()) {
                breads.clear();
                ingredients.clear();
                return;
            }
            if (OreDictionaryHelper.doesStackMatchOre(ingredientStack, "categoryBread")) {
                breads.add(ingredientCap.getData());
                continue;
            }
            ingredients.add(ingredientCap.getData());
        }
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            CraftingHelper.ShapedPrimer primer = RecipeUtils.parsePhaped(context, json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            int damage = JsonUtils.func_151204_g((JsonObject)json, (String)"damage") ? JsonUtils.func_151203_m((JsonObject)json, (String)"damage") : 1;
            return new SandwichRecipe(group.isEmpty() ? null : new ResourceLocation(group), primer, result, damage);
        }
    }
}

